
// BIPayment.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.

/*!
    @class       BIPayment
    @abstract    BIPayment is a representation of a payment which can either be applied to a particular invoice or to a project in general
    @discussion  ...
*/



#ifdef BILLINGS_PRO
#import "_BPPayment.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BIPayment.h"
#endif
#import "BIAppVersioning.h"


@class BIDatabaseObjectContext;

@interface BIPayment : BL_SUPER_CLASSNAME_MUNGE(Payment) 
{
}

- (void)setDefaultValues;

- (void)setInitialValues;
- (void)setInitialValuesWithObjectContext:(id)oc;

- (NSNumber *)appliedAmount;
- (NSNumber *)unappliedAmount;
- (BOOL)hasUnappliedAmount;

- (NSString*)tabDelimitedRepresentation:(NSArray*)fieldDicts;

- (BIPaymentMethodType*)defaultPaymentMethodUsingObjectContext:(BIDatabaseObjectContext*)oc;

- (NSCalendarDate*)statementDate;
- (void)setStatementDate:(NSCalendarDate*)aDate;

- (NSString*)methodString;

- (NSCalendarDate *)dateForAccount;

- (NSNumberFormatter *)currencyFormatter;

// If paid in actual base currency, returns that. If total is in base currency, returns that. Otherwise returns nil.
- (NSNumber *)baseTotal;
// if all else fails, applies the conversion rate
- (NSNumber *)exchangedBaseTotal;


- (NSString *)temporaryRetainerHistoryOnInvoiceTitle;
- (NSNumber *)temporaryRetainerHistoryOnInvoiceDisbursement;
- (NSNumber *)temporaryRetainerHistoryOnInvoiceAmount;

@end
